<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.792157064 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A35" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA35INST_RETIRED &gt; 0), (($BranchMPKICortexA35BR_MIS_PRED / $BranchMPKICortexA35INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA35INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA35CPU_CYCLES / $CyclesPerInstructionCortexA35INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA35INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA35CRYPTO_SPEC / $CryptoOperationsPercentageCortexA35INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA35INST_SPEC &gt; 0), min(($IntegerOperationsPercentageCortexA35DP_SPEC / $IntegerOperationsPercentageCortexA35INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA35CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA35INST_RETIRED / $InstructionsPerCycleCortexA35CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA35L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA35L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA35L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA35INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA35L1D_CACHE_REFILL / $L1DCacheMPKICortexA35INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA35INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA35L1D_TLB_REFILL / $L1DataTLBMPKICortexA35INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA35L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA35L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA35L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA35INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA35L1I_CACHE_REFILL / $L1ICacheMPKICortexA35INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA35INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA35L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA35INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Instructions Percentage">
        <series color="19,148,180" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA35INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA35INST_RETIRED / $RetiredInstructionsPercentageCortexA35INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA35INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA35VFP_SPEC / $FloatingPointOperationsPercentageCortexA35INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA35INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA35ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA35INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A35_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A35_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A35_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A35_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A35_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A35_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A35_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A35_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A35_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A35_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A35_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A35_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A35_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A35_metric_simd_percentage" />
</template>
